'===============================================================================
'
'               RN-AVR-Universal Funk 28.04.2012
'
'                + RFM12 433 als OOK Sender
'
'                    usb__mon Version 3.0
'
'                      www.dh2faa.de
'
'===============================================================================
'
' Compiliert mit Bascom 2.0.7.3
'
'===============================================================================
'
'
'                                  |---------------|
'                                  |               |
'          PB6 MISO            SDO +               + nSEL      PB4 /SS
'                                  |               |
'                             nIRQ +  QQ     o     + SCK       PB7 SCK
'                                  |  QQ    ooo    |
'    VCC --R=1K---   FSK/DATA/nFFS +  QQ   o o o   + SDI       PB5 MOSI
'                                  |  QQ    ooo    |
'          PD2 INT0 DCLK/CFIL/FFIT +  QQ     o     + nINT/VDI
'                                  |  QQ           |
'                              CLK +  QQ           + GND       GND
'                                  |  QQ           |
'                             nRES +  QQ   RFM12   + Vdd       Vcc
'                                  |               |
'                              GND +               + ANT       19cm Draht
'                                  |               |
'                                  |---------------|
'

'===============================================================================


'-------------------------------------------------------------------------------
'Compilereinstellungen
'-------------------------------------------------------------------------------
$regfile = "m644pdef.dat"

$hwstack = 40
$swstack = 50
$framesize = 60

$crystal = 8000000

$baud = 64000                                               ' USB Speed


'-------------------------------------------------------------------------------
'config
'-------------------------------------------------------------------------------

Config Watchdog = 1024

'UART fr USB, buffered
Config Serialin = Buffered , Size = 20

' Status LED
Statusled Alias Portd.6
Config Statusled = Output
Reset Statusled


'-------------------------------------------------------------------------------

'SPI Hardware
Config Spi = Hard , Interrupt = Off , Data Order = Msb , Master = Yes , Polarity = Low , Phase = 0 , Clockrate = 4 , Noss = 1

'SPI_SS wird selbst gesteuert
Spi_cs Alias Portb.4
Config Spi_cs = Output                                      ' SS


'-------------------------------------------------------------------------------
'  const
'-------------------------------------------------------------------------------

'Version
Const Weburl = "www.dh2faa.de"
Const Software = "USB__MON Version 3.0"
Const Hardware = "RN-AVR Universal Funk"

'ASCII Carriage Return
Const Asc_cr = 13

'eeprom adressen
Const E_adr_system = 0
Const E_adr_unit = 7
Const E_adr_poweradr = 16


'RFM-12 Power
Const Lowp = &H9857
Const Midp = &H9854
Const Higp = &H9850


'-------------------------------------------------------------------------------
' Declare Subroutine and Functions
'-------------------------------------------------------------------------------

Declare Sub Resetall
Declare Sub Init
Declare Sub Verarbeite_usb
Declare Sub Ausgabe_infodaten
Declare Sub Ausgabe_steckdose

Declare Sub Init_funkmodul
Declare Sub Spi_send(byval W_cmd2spi As Word)

Declare Sub Sende_0
Declare Sub Sende_1
Declare Sub Sende_f
Declare Sub Schalte
Declare Sub Sende_synch
Declare Sub Sender_ein
Declare Sub Sender_aus

Declare Sub Setsys
Declare Sub Setswi
Declare Sub Setsta

Declare Sub Save01

'-------------------------------------------------------------------------------
' Globale Variablen
'-------------------------------------------------------------------------------

Dim S_cin As String * 1
Dim S_cmd As String * 30
Dim S_cmd2 As String * 6


Dim B_mydebug As Byte

'
Dim W_rfpower As Word
Dim B_spio(2) As Byte


'funk433 ook
Dim S_system As String * 5
Dim S_unit As String * 5
Dim S_zustand As String * 2
Dim S_tx_data As String * 12
Dim S_bit As String * 1

Dim B_index As Byte
Dim B_repeat As Byte

Dim I_tx_delay As Integer

Dim S_help5 As String * 5
Dim S_help2 As String * 2



'-------------------------------------------------------------------------------
' Programmbereich
'-------------------------------------------------------------------------------

'-------------------------------------------------------------------------------
' Start
'-------------------------------------------------------------------------------


' Init. var.
B_mydebug = 0
I_tx_delay = 340


' Meldungen ausgeben
Call Ausgabe_infodaten

'Init SPI state and pins.
Print "Init SPI...";
Spiinit

Print "Init RFM12"
Call Init_funkmodul

'Leistung holen aus eeprom
Readeeprom W_rfpower , E_adr_poweradr

If W_rfpower = &HFFFF Then
   W_rfpower = Higp
   Writeeeprom W_rfpower , E_adr_poweradr
End If

'Set Power
Call Spi_send(w_rfpower)
Print "RFPower=" ; Hex(w_rfpower)


'Hole zuletzt gespeicherte Daten fr system und unit
Readeeprom S_system , E_adr_system
Readeeprom S_unit , E_adr_unit

'
S_zustand = "0f"                                            '0f=ein  f0=aus

'Ausgabe der gespeicherten Werte
Call Ausgabe_steckdose


'Signalisiere durch leuchten der LED 1 sek. das Hauptschleife startet
Reset Statusled
Wait 1
Set Statusled

'Erlaube Interrupts damit Pufferung des UART/USB funktioniert
Enable Interrupts



'-------------------------------------------------------------------------------
' Hauptschleife
'-------------------------------------------------------------------------------

Do

 Call Verarbeite_usb

Loop




'===============================================================================
' Hier ist der Code fr Funktionen und Prozeduren
'===============================================================================


'-------------------------------------------------------------------------------
' Komplettreset des Systems via watchdog
'-------------------------------------------------------------------------------
Sub Resetall
    Start Watchdog
    Do
    Loop
End Sub




'-------------------------------------------------------------------------------
' Ausgabe der Infodaten
'-------------------------------------------------------------------------------
Sub Ausgabe_infodaten
  Print Weburl
  Print "SW:" ; Software
  Print "HW:" ; Hardware
End Sub



'-------------------------------------------------------------------------------
' Eingaben via USB verarbeiten
'-------------------------------------------------------------------------------
Sub Verarbeite_usb
 If Ischarwaiting() > 0 Then
   S_cmd = ""
   S_cin = ""

   Do
     If Ischarwaiting() = 1 Then
       S_cin = Waitkey()
       S_cmd = S_cmd + S_cin
     End If
   Loop Until Asc(s_cin) = Asc_cr Or Len(s_cmd) >= 25


   S_cmd = Lcase(s_cmd)

   If B_mydebug = 1 Then Print ">" ; S_cmd ; "<"

   S_cmd2 = Left(s_cmd , 6)

  Select Case S_cmd2

    Case "debug1" : B_mydebug = 1

    Case "debug0" : B_mydebug = 0

    Case "reset0" : Call Resetall

    Case "getver" : Call Ausgabe_infodaten

    Case "setsys" : Call Setsys

    Case "setswi" : Call Setswi

    Case "setsta" : Call Setsta

    Case "getsys" : Print S_system

    Case "getswi" : Print S_unit

    Case "getsta" : Print S_zustand

    Case "save01" : Call Save01

    Case "setpwl" :
      W_rfpower = Lowp
      Call Spi_send(w_rfpower)
      Writeeeprom W_rfpower , E_adr_poweradr

    Case "setpwm" :
      W_rfpower = Midp
      Call Spi_send(w_rfpower)
      Writeeeprom W_rfpower , E_adr_poweradr

    Case "setpwh" :
      W_rfpower = Higp
      Call Spi_send(w_rfpower)
      Writeeeprom W_rfpower , E_adr_poweradr

    Case Else : Print "Hh?"

   End Select
   Clear Serialin
 End If
End Sub


'-------------------------------------------------------------------------------
' Initialisierung des Funkmoduls
'-------------------------------------------------------------------------------
Sub Init_funkmodul
Dim Widat As Word
   Waitms 50
   Restore Init_data
   Do
     Read Widat
     If Widat = &HFFFF Then
       Exit Do
     End If
     Call Spi_send(widat)
     Print Hex(widat) ; ":" ;
     Waitms 50
   Loop
   Print "-"
End Sub


'-------------------------------------------------------------------------------
' Daten an Funkmodul mittels SPI senden
'-------------------------------------------------------------------------------
Sub Spi_send(byval W_cmd2spi As Word)
  B_spio(1) = High(w_cmd2spi)
  B_spio(2) = Low(w_cmd2spi)
  Reset Spi_cs
  Spiout B_spio(1) , 2
  Set Spi_cs
End Sub


'-------------------------------------------------------------------------------
' Senden 0 ber die Funkstrecke
'-------------------------------------------------------------------------------
Sub Sende_0
 Call Sender_ein
 Waitus I_tx_delay
 Call Sender_aus
 Waitus I_tx_delay
 Waitus I_tx_delay
 Waitus I_tx_delay
 '
 Call Sender_ein
 Waitus I_tx_delay
 Call Sender_aus
 Waitus I_tx_delay
 Waitus I_tx_delay
 Waitus I_tx_delay
End Sub


'-------------------------------------------------------------------------------
' Senden F ber die Funkstrecke
'-------------------------------------------------------------------------------
Sub Sende_f
 Call Sender_ein
 Waitus I_tx_delay
 Call Sender_aus
 Waitus I_tx_delay
 Waitus I_tx_delay
 Waitus I_tx_delay
 '
 Call Sender_ein
 Waitus I_tx_delay
 Waitus I_tx_delay
 Waitus I_tx_delay
 Call Sender_aus
 Waitus I_tx_delay
End Sub


'-------------------------------------------------------------------------------
' Senden 1 ber die Funkstrecke
'-------------------------------------------------------------------------------
Sub Sende_1
 Call Sender_ein
 Waitus I_tx_delay
 Waitus I_tx_delay
 Waitus I_tx_delay
 Call Sender_aus
 Waitus I_tx_delay
 '
 Call Sender_ein
 Waitus I_tx_delay
 Waitus I_tx_delay
 Waitus I_tx_delay
 Call Sender_aus
 Waitus I_tx_delay
End Sub


'-------------------------------------------------------------------------------
' Senden synchrondaten ber die Funkstrecke
'-------------------------------------------------------------------------------
Sub Sende_synch
  Call Sender_ein
  Waitus I_tx_delay
  Call Sender_aus
  For B_index = 1 To 31
    Waitus I_tx_delay
  Next
End Sub



'-------------------------------------------------------------------------------
' Sende eines kompletten Funkblocks bestehend aus System, Unit und Zustand
'-------------------------------------------------------------------------------
Sub Schalte
S_tx_data = S_system + S_unit + S_zustand

Call Ausgabe_steckdose

'Disable Interrupts

For B_repeat = 1 To 3

 For B_index = 1 To Len(s_tx_data)
   S_bit = Mid(s_tx_data , B_index , 1)
   Select Case S_bit
   Case "1"
     Call Sende_1
   Case "0"
     Call Sende_0
   Case "f"
     Call Sende_f
   End Select
 Next I1

 Call Sende_synch

'Enable Interrupts

Next Repeat

End Sub


'-------------------------------------------------------------------------------
' Einschalten des Senders, Status LED einschalten
'-------------------------------------------------------------------------------
Sub Sender_ein
  Reset Statusled
  Call Spi_send(&H8278)
End Sub

'-------------------------------------------------------------------------------
' Ausschalten des Senders, Status LED ausschalten
'-------------------------------------------------------------------------------
Sub Sender_aus
  Set Statusled
  Call Spi_send(&H8258)
End Sub


'-------------------------------------------------------------------------------
' Systemwert aus USB-Kommando ermitteln (setsys=xxxxx)
'-------------------------------------------------------------------------------
Sub Setsys
  If Len(s_cmd) >= 12 Then
     S_system = Mid(s_cmd , 8 , 5)
     Call Ausgabe_steckdose
  Else
     Print "Err:>" ; S_cmd ; "<"
  End If
End Sub


'-------------------------------------------------------------------------------
' Unitwert aus USB-Kommando ermitteln (setswi=xxxx)
'-------------------------------------------------------------------------------
Sub Setswi
  If Len(s_cmd) >= 12 Then
     S_unit = Mid(s_cmd , 8 , 5)
     Call Ausgabe_steckdose
  Else
     Print "Err:>" ; S_cmd ; "<"
  End If
End Sub

'-------------------------------------------------------------------------------
' Zustandswert aus USB-Kommando ermitteln (setsta=xx), dann schalten
'-------------------------------------------------------------------------------
Sub Setsta
  If Len(s_cmd) >= 9 Then
     S_zustand = Mid(s_cmd , 8 , 2)
     Call Schalte
  Else
      Print "Err:>" ; S_cmd ; "<"
  End If
End Sub

'-------------------------------------------------------------------------------
' systemwert und Unitwert in EEPROM speichern
'-------------------------------------------------------------------------------
Sub Save01
 Writeeeprom S_system , E_adr_system
 Writeeeprom S_unit , E_adr_unit
End Sub


'-------------------------------------------------------------------------------
' Ausgabe der Daten einer Steckdose
'-------------------------------------------------------------------------------
Sub Ausgabe_steckdose
 Print "System:" ; S_system ; " Unit:" ; S_unit ; " Zustand:" ; S_zustand
End Sub



End

'===============================================================================
' Datenbereich (im Flash)
'===============================================================================
Init_data:
'
Data &H0000%
Data &H8097%                                                'Configuration:      433MHz-Band, 12pf
Data &H8258%                                                'Power Management:   ES, EX, ET off
Data &HA620%                                                'Frequency:          433.92MHz
Data &HC623%                                                'Data Rate Command
Data &H9088%                                                'RX Control:   134kHz, -97dbm --- wird nicht bentigt
Data &HC2AC%                                                'Data Filter Command Digital,slow, Threshold 4
Data &HCA81%                                                'FIFO  low, synchron 2Bytes
Data &HC4D4%                                                'AFC  VDI=high,  no restric
Data &H9850%                                                'TX Control, 90KHz, -0dB = max
Data &HE001%                                                'wake-up
Data &HC800%                                                'low duty-cycle D=0
Data &HCC77%                                                'PLL Settings
Data &HC000%                                                'low battery, clock  10 MHz

' ende markierung
Data &HFFFF%

'-------------------------------------------------------------------------------